package com.biz.crm.nebular.kms.returnform.resp;

import com.biz.crm.config.CrmColumnResolve;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 退货单详情表返回vo
 *
 * @author Gavin
 * @date 2021-05-12 18:23:07
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "退货单详情表")
@CrmColumnResolve
public class KmsReturnFormExportRespVo extends KmsReturnFormRespVo {
    private static final long serialVersionUID = -8666841690063476774L;
    @ApiModelProperty("租户ID")
    private String tenantryId;

    @ApiModelProperty("原始数据ID 对应表 kms_grab_response_data 的ID")
    private String rawDataId;

    @ApiModelProperty("抓单生成的退货单编号")
    private String orderNumber;

    @ApiModelProperty("订单版本号")
    private Integer versionNumber;

    @ApiModelProperty("商超退货单编号")
    private String kaOrderNumber;

    @ApiModelProperty("单据当前状态")
    private String orderStatus;

    @ApiModelProperty("单据当前状态信息")
    private String orderStatusMsg;

    @ApiModelProperty("企业产品编号")
    private String goodsCode;

    @ApiModelProperty("企业产品名称")
    private String goodsName;

    /**
     * 关联ID(企业商品与商超商品表ID)
     */
    @ApiModelProperty("关联ID(企业商品与商超商品表ID)")
    private String goodsRelatedId;

    @ApiModelProperty("商超产品编号")
    private String kaGoodsCode;

    @ApiModelProperty("商超产品名称")
    private String kaGoodsName;

    @ApiModelProperty("产品国际条码")
    private String goodsBarCode;

    @ApiModelProperty("产品规格")
    private String specification;

    @ApiModelProperty("退货单价（含税）")
    private String unitPrice;

    @ApiModelProperty("退货金额小计（含税）")
    private String returnAmount;

    @ApiModelProperty("退货单价（不含税）")
    private String unitPriceNot;

    @ApiModelProperty("退货金额小计（不含税）")
    private String returnAmountNot;

    @ApiModelProperty("字段转换标识：0失败，1成功")
    private String transStatus;

    @ApiModelProperty("售达方名称")
    private String soldToPartyName;

    @ApiModelProperty("售达方编码")
    private String soldToPartyCode;

    @ApiModelProperty("当前单位层级")
    private String curUnitLevel;

    @ApiModelProperty("当前单位")
    private String curUnit;

    @ApiModelProperty("当前单位退货数量")
    private String curUnitOrderQuantity;

    @ApiModelProperty("单位转换比例系数")
    private BigDecimal ratio;

    /**
     * 企业单位数量
     */
    @ApiModelProperty("企业单位数量")
    private BigDecimal numerator;

    @ApiModelProperty("企业当前单位")
    private String curCompanyUnit;

    @ApiModelProperty("企业当前单位订货数量")
    private String curCompanyUnitOrderQuantity;

    @ApiModelProperty("最小单位层级")
    private String minUnitLevel;

    @ApiModelProperty("最小单位")
    private String minUnit;

    @ApiModelProperty("最小单位订货数量")
    private String minUnitOrderQuantity;

    @ApiModelProperty("最大单位层级")
    private String maxUnitLevel;

    @ApiModelProperty("最大单位")
    private String maxUnit;

    @ApiModelProperty("最大单位订货数量")
    private String maxUnitOrderQuantity;

    @ApiModelProperty("商超名称")
    private String kaName;

    @ApiModelProperty("行信息排序")
    private Integer itemIndex;

    @ApiModelProperty("行状态信息描述")
    private String itemStatusMsg;
}