package com.biz.crm.nebular.kms.supermarket.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 售达方与供应商关系表返回vo
 *
 * @author gavin
 * @date 2021-07-06 13:58:17
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "售达方与供应商关系表")
public class KmsSupplierRespVo extends CrmExtTenVo {
    private static final long serialVersionUID = -841338535334368011L;
    @ApiModelProperty("直营体系Id")
    private String bsDirectSystemId;

    @ApiModelProperty("直营体系编码")
    private String bsDirectSystemCode;

    @ApiModelProperty("直营体系名称")
    private String bsDirectSystemName;

    @ApiModelProperty("售达方Id")
    private String sellPartyId;

    @ApiModelProperty("售达方编码")
    private String sellPartyCode;

    @ApiModelProperty("售达方名称")
    private String sellPartyName;

    @ApiModelProperty("供应商编码")
    private String supplierCode;

    @ApiModelProperty("所属公司")
    private String ownedCompany;
}