package com.biz.crm.nebular.mdm.approval.req;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 审批配置主表请求vo
 *
 * @author Tao.Chen
 * @date 2021-03-01 17:50:29
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmApprovalConfigReqVo", description = "审批配置主表")
public class MdmApprovalConfigReqVo extends CrmBaseVo {

    @ApiModelProperty("菜单编码")
    private String menuCode;

    @ApiModelProperty("菜单名称")
    private String menuName;

    @ApiModelProperty("业务编码")
    private String businessCode;

    @ApiModelProperty("业务名称")
    private String businessName;

    @ApiModelProperty("审批开关：1是 0否")
    private String controlFlag;

    @ApiModelProperty("审批类型")
    private String approvalType;

    @ApiModelProperty("自动发起流程审批的流程key")
    private String defaultWorkFlowKey;

    @ApiModelProperty("控制范围")
    private String controlScope;

    @ApiModelProperty("条件判断逻辑")
    private String groupCheckWay;

    @ApiModelProperty("业务数据条件集合")
    private List<MdmApprovalConfigConditionReqVo> conditionList;

    @ApiModelProperty("提交人条件集合")
    private List<MdmApprovalConfigSubmitterReqVo> submitterList;

}