package com.biz.crm.nebular.mdm.customer;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Project crm
 * @PackageName com.biz.crm.nebular.mdm.customer
 * @ClassName MdmCustomerRespVo
 * @Author Gavin
 * @Date 2021/6/3 下午2:42
 * @Description 客户信息
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "客户信息")
public class MdmCustomerRespVo extends CrmExtTenVo {
    private static final long serialVersionUID = -2809324579541348865L;

    /**
     * 高德地图ID
     */
    private String amapId;

    /**
     * 终端编码
     */
    private String terminalCode;

    /**
     * 渠道
     */
    private String channel;

    /**
     * 客户编码
     */
    private String customerCode;

    /**
     * 客户组织编码
     */
    private String customerOrgCode;

    /**
     * 客户组织类型
     */
    private String customerOrgType;

    /**
     * 客户名称
     */
    private String customerName;

    /**
     * 客户类型
     */
    private String customerType;

    /**
     * 操作类型
     */
    private String operateType;

    /**
     * 企业组织编码
     */
    private String orgCode;


    /**
     * 市
     */
    private String cityCode;

    private String cityName;

    /**
     * 区
     */
    private String districtCode;

    private String districtName;

    /**
     * 省
     */
    private String provinceCode;

    private String provinceName;

    /**
     * 注册地址
     */
    private String registeredAddress;

    /**
     * 工程名
     */
    private String projectName;

    /**
     * 客户联系方式
     */
    private String customerContact;

    /**
     * 客户法人代表
     */
    private String legalRepresentative;

    /**
     * 用户帐号
     */
    private String userName;

    /**
     * 是否是主客户：1是0否
     */
    private String customerPrimary;

    /**
     * 锁定状态：009正常，003冻结
     */
    private String lockState;

    @ApiModelProperty("经度")
    private String longitude;
    @ApiModelProperty("纬度")
    private String latitude;
    @ApiModelProperty("erp编码")
    private String erpCode;

    @ApiModelProperty("审批状态,枚举MdmBpmStatusEnum")
    private String actApproveStatus;

    @ApiModelProperty("价格组")
    private String priceGroup;
    @ApiModelProperty("合作状态")
    private String cooperateStatus;

    /**
     * 审批类型
     */
    private String approvalType;

    /**
     * 流程编号
     */
    private String processCode;

    /**
     * 数据字典source_type
     */
    private String sourceType;

    /**
     * 业务来源系统
     */
    private String fromType;

}