package com.biz.crm.nebular.mdm.customermaterial.resp;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnDomain;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;


/**
 * 客户物料返回vo
 *
 * @author huang.long
 * @date 2020-09-02 22:09:56
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "客户物料")
@SaturnDomain(value = "mdmcustomermaterialrespvo")
@SaturnEntity(name = "MdmCustomerMaterialRespVo", description = "客户物料")
public class MdmCustomerMaterialRespVo extends CrmExtVo {
    @ApiModelProperty("客户组织编码")
    @SaturnColumn(description = "客户组织编码")
    private String customerOrgCode;

    @ApiModelProperty("客户组织名称")
    @SaturnColumn(description = "客户组织名称")
    private String customerOrgName;

    @ApiModelProperty("物料编码")
    @SaturnColumn(description = "物料编码")
    private String materialCode;

    @ApiModelProperty("物料名称")
    @SaturnColumn(description = "物料名称")
    private String materialName;

    @ApiModelProperty("条形码")
    @SaturnColumn(description = "条形码")
    private String barCode;

}
