package com.biz.crm.nebular.mdm.material;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import lombok.Data;

/**
 * mdm侧物料分页查询dto
 *
 * @Author: hecheng
 */
@Data
@ApiModel
public class MaterialMdmPaginationDto extends PageVo implements Serializable {

  private static final long serialVersionUID = 925824147679953235L;

  /**
   * 物料编码
   */
  @ApiModelProperty("物料编码")
  private String materialCode;
  /**
   * 物料名称
   */
  @ApiModelProperty("物料名称")
  private String materialName;
  /**
   * 商品层级编码
   * <pre>
   *   "brand":"品牌"
   *   "series":"系列"
   *   "max":"大类"
   *   "min":"细类"
   * </pre>
   */
  @ApiModelProperty("商品层级类型")
  private String productLevelType;
  /**
   * 商品层级编码集合
   */
  @ApiModelProperty("商品层级编码集合")
  private List<String> productLevelCodes;

  /**
   * 物料编码集合
   */
  @ApiModelProperty("物料编码集合")
  private List<String> materialCodes;
  /**
   * 开始时间
   */
  @ApiModelProperty("开始时间")
  private String startDate;
  /**
   * 结束时间
   */
  @ApiModelProperty("结束时间")
  private String endDate;


  /**
   * 启用禁用
   */
  @ApiModelProperty("启用禁用")
  private String enableStatus;



}
