package com.biz.crm.nebular.mdm.material;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @ClassName: MdmMaterialMediaReqVo
 * @Author: yangfan
 * @Description: 物料照片信息请求vo
 * @Date: 2021/8/16 14:42
 * @Version: 1.0
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
public class MdmMaterialMediaReqVo extends CrmBaseVo {
  @ApiModelProperty("ID集合")
  private List<String> ids;

  @ApiModelProperty("地址")
  private String urlAddress;

  @ApiModelProperty("物料编码")
  private String materialCode;

  @ApiModelProperty("物料id")
  private String materialId;

  @ApiModelProperty("排序位置")
  private Integer rangeNum;

  @ApiModelProperty("图片类型 central 主图片 display 陈列图片 detail 详情图片")
  private String businessType;

  @SaturnColumn(description = "文件名称")
  @ApiModelProperty("文件名称")
  private String fileName;

  @SaturnColumn(description = "源文件名称")
  @ApiModelProperty("源文件名称")
  private String originalFileName;

  @SaturnColumn(description = "目录")
  @ApiModelProperty("目录")
  private String relativeLocal;
}
