package com.biz.crm.nebular.mdm.material;

import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @ClassName: MdmMaterialMediaRespVo
 * @Author: yangfan
 * @Description: 物料照片信息返回vo
 * @Date: 2021/8/16 14:43
 * @Version: 1.0
 */
@ApiModel(value = "物料图片")
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@SaturnEntity(name = "MdmProductPictureRespVo", description = "物料图片信息")
public class MdmMaterialMediaRespVo extends UuidVo{

  @ApiModelProperty("地址")
  @SaturnColumn(description = "链接地址")
  private String urlAddress;

  @ApiModelProperty("物料编码")
  @SaturnColumn(description = "物料编码")
  private String materialCode;

  @ApiModelProperty("物料id")
  @SaturnColumn(description = "物料id")
  private String materialId;

  @ApiModelProperty("排序位置")
  @SaturnColumn(description = "排序位置")
  private Integer rangeNum;

  @ApiModelProperty("图片类型 central 主图片 display 陈列图片 detail 详情图片")
  @SaturnColumn(description = "图片类型")
  private String businessType;

  @SaturnColumn(description = "文件名称")
  @ApiModelProperty("文件名称")
  private String fileName;

  @SaturnColumn(description = "源文件名称")
  @ApiModelProperty("源文件名称")
  private String originalFileName;

  @SaturnColumn(description = "目录")
  @ApiModelProperty("目录")
  private String relativeLocal;

}
