package com.biz.crm.nebular.mdm.material;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 请求vo
 *
 * @author zxw
 * @date 2020-09-01 19:55:17
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "MdmMaterialReqVo", description = "")
@Accessors(chain = true)
public class MdmMaterialReqVo extends CrmTreeVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("产品层级编码")
    private String productLevelCode;

    @ApiModelProperty("物料编码")
    private String materialCode;

    @ApiModelProperty("产品名称")
    private String materialName;

    @ApiModelProperty("产品层级名称")
    private String productLevelName;

    @ApiModelProperty("ai编码")
    private String aiCode;

    @ApiModelProperty("条形码")
    private String barCode;

    @ApiModelProperty("基本单位")
    private String baseUnit;

    @ApiModelProperty("物料类型")
    private String materialType;

    @ApiModelProperty("销售公司编码（列表显示用）。多个编码用逗号隔开")
    private String saleCompany;

    @ApiModelProperty("销售公司（新增入参和编辑回传）")
    private List<String> saleCompanyList;

    @ApiModelProperty("销售单位")
    private String saleUnit;

    @ApiModelProperty("规格")
    private String specification;

    @ApiModelProperty("单位换算系数")
    private String unitConversion;

    @ApiModelProperty("成本价格")
    private String costPrice;

    @ApiModelProperty("产品层级树编码字段")
    private String code;

    @ApiModelProperty("开始时间")
    private String startTime;

    @ApiModelProperty("结束时间")
    private String endTime;

    @ApiModelProperty("毛重")
    private String grossWeight;

    @ApiModelProperty("净重")
    private String netWeight;

    @ApiModelProperty("容量")
    private String capacity;

    /**
     * 标准单位
     */
    @ApiModelProperty("标准单位")
    private String standardUnit;

    /**
     * 盒码单位转算系数
     */
    @ApiModelProperty("盒码单位转算系数")
    private BigDecimal boxUnitConversion;

    /**
     * 箱码单位转算系数
     */
    @ApiModelProperty("箱码单位转算系数")
    private BigDecimal caseUnitConversion;


    @ApiModelProperty("图片信息")
    private List<MdmMaterialMediaReqVo> picList;


    @ApiModelProperty("商品层级编码集合")
    private List<String> productLevelCodes;

    @ApiModelProperty("物料编码集合")
    private List<String> materialCodes;

    @ApiModelProperty("商品层级类型")
    private String productLevelType;



}