package com.biz.crm.nebular.mdm.pricesetting.resp;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.nebular.mdm.pricesetting.resp
 * @Description: TODO
 * @date 2020/12/8 下午4:20
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "系统查询价格封装类 ")
@CrmColumnResolve
public class MdmPriceResp extends CrmExtVo {
    @ApiModelProperty("商品编码")
    private String productCode;

    @ApiModelProperty("价格")
    private BigDecimal price;

    @ApiModelProperty("条件类型编码")
    private String conditionTypeCode;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("渠道")
    private String channel;

    @ApiModelProperty("终端编码")
    private String terminalCode;

    @ApiModelProperty("价格组")
    private String priceGroup;

    @ApiModelProperty("条件字段编码")
    private String conditionGroupCode;

    @ApiModelProperty("销售公司编码")
    private String saleCompanyCode;

    @ApiModelProperty("币种编码(字典currency_type)")
    private String currencyType;

    @ApiModelProperty("币种名称")
    private String currencyTypeName;

    @ApiModelProperty("单位类型 数据字典：unit_type")
    private String unitType;

    @ApiModelProperty("价格单位(字典,选项数据跟选择的商品有关)")
    private String priceUnit;

    @ApiModelProperty("价格单位名称")
    private String priceName;

    private Integer filterSort;

    @ApiModelProperty("客户类型")
    private String customerType;

    @ApiModelProperty("终端类型")
    private String terminalType;
}
