package com.biz.crm.nebular.mdm.terminal;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author yangshan
 * @date 2021/4/14 21:23
 */
@Data
@ApiModel("腾讯地图客户数据 ")
public class MdmTencentMapData implements Serializable {

    private static final long serialVersionUID = 1L;

    private List<MdmTencentMapDataReqVo> data;

    @Data
    public static class MdmTencentMapDataReqVo {

        @ApiModelProperty("售点ID")
        private String poiId;

        @ApiModelProperty("售点名称")
        private String poiTitle;

        @ApiModelProperty("售点地址")
        private String poiAddress;

        @ApiModelProperty("省份")
        private String province;

        @ApiModelProperty("城市")
        private String city;

        @ApiModelProperty("区县")
        private String district;

        @ApiModelProperty("商圈标签")
        private String busiLabel;

        @ApiModelProperty("经度")
        private String lng;

        @ApiModelProperty("纬度")
        private String lat;

        @ApiModelProperty("渠道")
        private String channel;

        @ApiModelProperty("业态")
        private String busiType;

        @ApiModelProperty("距离")
        private String distance;

        @ApiModelProperty("品牌编码")
        private String brandId;

        @ApiModelProperty("品牌名称")
        private String brandName;

        @ApiModelProperty("业务员编码")
        private String userName;

        @ApiModelProperty("业务员编码")
        private String userId;
    }
}
