package com.biz.crm.nebular.mdm.terminal.resp;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleReqVo;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleRespVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @author ql
 * @date 2021/2/5
 * @time 9:11
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "终端详细信息响应VO")
@CrmColumnResolve
public class MdmTerminalDetailRespVo extends CrmExtTenVo {

    /**
     * 终端编码
     */
    @ApiModelProperty("终端编码")
    private String terminalCode;

    /**
     * 终端名称
     */
    @ApiModelProperty("终端名称")
    private String terminalName;

    /**
     * 终端类型
     */
    @ApiModelProperty("终端类型")
    private String terminalType;

    /**
     * 所属组织编码
     */
    @ApiModelProperty("所属组织编码")
    private String orgCode;

    /**
     * 客户组织编码
     */
    @ApiModelProperty("客户组织编码")
    private String customerOrgCode;

    /**
     * 渠道
     */
    @ApiModelProperty("渠道")
    private String channel;

    /**
     * 营业执照法人姓名
     */
    @ApiModelProperty("营业执照法人姓名")
    private String licensePersonName;

    /**
     * 营业执照注册号
     */
    @ApiModelProperty("营业执照注册号")
    private String licenseRegisterNumber;

    /**
     * 营业执照企业名称
     */
    @ApiModelProperty("营业执照企业名称")
    private String licenseFirmName;

    /**
     * 终端地址
     */
    @ApiModelProperty("终端地址")
    private String terminalAddress;

    /**
     * 省
     */
    @ApiModelProperty("省编码")
    private String provinceCode;

    /**
     * 市
     */
    @ApiModelProperty("市编码")
    private String cityCode;

    /**
     * 区
     */
    @ApiModelProperty("区编码")
    private String districtCode;

    /**
     * 店招照片
     */
    @ApiModelProperty("店招照片")
    private String shopImagePath;

    /**
     * 营业执照照片
     */
    @ApiModelProperty("营业执照照片")
    private String licenseImagePath;

    /**
     * 经度
     */
    @ApiModelProperty("经度")
    private String longitude;

    /**
     * 纬度
     */
    @ApiModelProperty("纬度")
    private String latitude;

    @ApiModelProperty("客户分类")
    private String customerClassification;

    @ApiModelProperty("审批状态,枚举MdmBpmStatusEnum")
    private String actApproveStatus;

    /**
     * 终端关联角色信息
     */
    @ApiModelProperty("终端关联角色信息")
    private List<String> roleCodeList;
}
