package com.biz.crm.nebular.mdm.user.req;

import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 权限角色-经销商员工用户关联：分页请求
 *
 * @author Tao.Chen
 * @date 2021-04-21 10:21:12
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmCustomerUserRelRolePageReqVo", description = "权限角色-经销商员工用户关联：分页请求")
public class MdmCustomerUserRelRolePageReqVo extends PageVo {

    @ApiModelProperty("权限角色编码")
    private String roleCode;

    @ApiModelProperty("用户账号登录信息")
    private String userName;

    @Deprecated
    @ApiModelProperty("用户编码")
    private String userCode;

    @ApiModelProperty("用户类型")
    private String userType;

    @ApiModelProperty("性别")
    private String gender;

    @ApiModelProperty("电话")
    private String userPhone;

    @ApiModelProperty("人员姓名")
    private String fullName;

    @ApiModelProperty("邮箱")
    private String email;

    @ApiModelProperty("锁定状态 003/009")
    private String lockState;

    @ApiModelProperty("用户类型集合")
    private List<String> userTypeList;

}