package com.biz.crm.nebular.mdm.user.req;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 用户关联客户分页查询
 *
 * @author zxw
 * @date 2020-10-10 10:22
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmUserRelationCustomerPageReqVo", description = "用户关联客户分页查询请求")
public class MdmUserRelationCustomerPageReqVo extends CrmExtVo {

    @ApiModelProperty("用户帐号")
    private String userName;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("客户编码或名称")
    private String customerCodeOrName;

    @ApiModelProperty("客户类型")
    private String customerType;

    @ApiModelProperty("省编码")
    private String provinceCode;

    @ApiModelProperty("市编码")
    private String cityCode;

    @ApiModelProperty("区编码")
    private String districtCode;

    @ApiModelProperty("省名称")
    private String provinceName;

    @ApiModelProperty("市名称")
    private String cityName;

    @ApiModelProperty("区名称")
    private String districtName;

    @ApiModelProperty("审批状态,枚举MdmBpmStatusEnum")
    private String actApproveStatus;
}
