package com.biz.crm.nebular.mdm.user.resp;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.PageVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 权限角色-经销商员工用户关联：分页响应
 *
 * @author Tao.Chen
 * @date 2021-04-21 10:21:12
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmCustomerUserRelRolePageRespVo", description = "权限角色-经销商员工用户关联：分页响应")
public class MdmCustomerUserRelRolePageRespVo extends PageVo {

    @ApiModelProperty("用户账号登录信息")
    private String userName;

    @Deprecated
    @ApiModelProperty("用户编码")
    private String userCode;

    @ApiModelProperty("用户类型")
    private String userType;

    @ApiModelProperty("用户类型名称")
    @CrmDict(typeCode = DictConstant.USER_TYPE, dictCodeField = "userType")
    private String userTypeName;

    @ApiModelProperty("性别")
    private String gender;

    @ApiModelProperty("电话")
    private String userPhone;

    @ApiModelProperty("人员姓名")
    private String fullName;

    @ApiModelProperty("生效时间")
    private String endTime;

    @ApiModelProperty("失效时间")
    private String startTime;

    @ApiModelProperty("邮箱")
    private String email;

    @ApiModelProperty("锁定状态 003/009")
    private String lockState;

    @ApiModelProperty("最后一次登录时间")
    private String lastLoginTime;

    @ApiModelProperty("用户头像url")
    private String userHeadUrl;

    @ApiModelProperty("锁定状态")
    @CrmDict(typeCode = DictConstant.LOCK_STATE, dictCodeField = "lockState")
    private String lockStateName;

    @ApiModelProperty("用户与角色关联表id")
    private String relId;
}
