package com.biz.crm.nebular.sfa.actscheme.resp;

import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 活动方案范围;请求vo
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "活动方案范围;")
@SaturnEntity(name = "SfaActSchemeRangeRespVo", description = "活动方案范围;")
public class SfaActSchemeRangeRespVo extends UuidVo {

    @ApiModelProperty("方案id")
    @SaturnColumn(description = "方案id")
    private String actSchemeId;

    @ApiModelProperty("范围类型(0-组织,1-职位级别,2-职位)")
    @SaturnColumn(description = "范围类型(0-组织,1-职位级别,2-职位)")
    private String rangeType;

    @ApiModelProperty("编码")
    @SaturnColumn(description = "编码")
    private String code;

    @ApiModelProperty("名称")
    @SaturnColumn(description = "名称")
    private String name;

}