package com.biz.crm.nebular.sfa.asexecution.resp;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @Project crm
 * @PackageName com.biz.crm.nebular.sfa.asexecution.resp
 * @ClassName 方案活动执行商品头
 * @Author Gavin
 * @Date 2021/3/16 下午5:25
 * @Description
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "方案活动执行产品数据采集头;")
@SaturnEntity(name = "SfaAsExecutionProductTopVo", description = "方案活动执行产品数据采集头;")
public class SfaAsExecutionProductTopVo {

    @ApiModelProperty("执行id")
    @SaturnColumn(description = "执行id")
    private String executionId;

    @ApiModelProperty("方案套餐id")
    @SaturnColumn(description = "方案套餐id")
    private String setmealId;

    @ApiModelProperty("方案套餐商品信息")
    private List<SfaAsExecutionProductRespVo> productRespVos;
    @ApiModelProperty("套餐顺序")
    private String setmealOrder;
}