package com.biz.crm.nebular.sfa.asexecution.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 方案活动执行;返回vo
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "方案活动执行;")
@SaturnEntity(name = "SfaAsExecutionRespVo", description = "方案活动执行;")
public class SfaAsExecutionRespVo extends CrmExtTenVo {

    private static final long serialVersionUID = -6666303727168290143L;
    @ApiModelProperty("活动编码")
    @SaturnColumn(description = "活动编码")
    private String activityCode;

    @ApiModelProperty("终端编码")
    @SaturnColumn(description = "终端编码")
    private String terminalCode;

    @ApiModelProperty("终端名称")
    @SaturnColumn(description = "终端名称")
    private String terminalName;

    @ApiModelProperty("参与类型(0_免费参与/1_协议参与)")
    @SaturnColumn(description = "参与类型(0_免费参与/1_协议参与)")
    private String participateInType;

    @ApiModelProperty("陈列类型")
    @SaturnColumn(description = "陈列类型")
    private String displayType;

    @ApiModelProperty("陈列类型描述")
    private String displayTypeDesc;

    @ApiModelProperty("人员账号")
    @SaturnColumn(description = "人员账号")
    private String userName;

    @ApiModelProperty("人员姓名")
    @SaturnColumn(description = "人员姓名")
    private String realName;

    @ApiModelProperty("职位名称")
    @SaturnColumn(description = "职位名称")
    private String posName;

    @ApiModelProperty("职位编码")
    @SaturnColumn(description = "职位编码")
    private String posCode;

    @ApiModelProperty("组织名称")
    @SaturnColumn(description = "组织名称")
    private String orgName;

    @ApiModelProperty("组织编码")
    @SaturnColumn(description = "组织编码")
    private String orgCode;

    @ApiModelProperty("执行时间")
    @SaturnColumn(description = "执行时间")
    private String executionDate;

    @ApiModelProperty("拜访ID")
    private String visitPlanInfoId;

    @ApiModelProperty("方案活动执行图片")
    private List<SfaAsExecutionPictureTopVo> asExecutionPictureTopVos;

    @ApiModelProperty("方案活动执行产品数据采集")
    private List<SfaAsExecutionProductTopVo> asExecutionProductTopVos;
}