package com.biz.crm.nebular.sfa.integral.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 积分排名报表——Vo
 * @author YuanZiJian
 * @date 2021/1/12 15:59
 * @version: V1.0
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaIntegralRankRespVo", description = "积分排名报表 ")
public class SfaIntegralRankRespVo extends CrmExtTenVo {
    @ApiModelProperty("人员编码")
    private String userName;

    @ApiModelProperty("人员名字")
    private String fullName;

    @ApiModelProperty("职位名称")
    private String posName;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("职位等级名称")
    private String posLevelName;

    @ApiModelProperty("积分数")
    private Integer integralNum;

    @ApiModelProperty("排名")
    private Integer rank;
}
