package com.biz.crm.nebular.sfa.tpmact.resp;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * tpm活动明细商品返回vo
 *
 * @author lf
 * @date 2021-06-10 16:44:26
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "tpm活动明细商品")
public class SfaTpmActDetailProductRespVo extends CrmExtTenVo {
    @ApiModelProperty("活动编码")
    private String actCode;

    @ApiModelProperty("活动明细编码")
    private String actDetailCode;

    @ApiModelProperty("是否赠品(Y-赠品,N-本品)")
    private String isGiftProduct;

    @ApiModelProperty("产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    private String productName;

    @ApiModelProperty("对付方式(现金兑付,货品兑付)")
    private String paymentMethod;

    @ApiModelProperty("全国统一价")
    private BigDecimal price;

    @ApiModelProperty("sfa图片")
    private String sfaPicUrl;

    @ApiModelProperty("商品主图片")
    private String primaryPictureUrl;

    @ApiModelProperty("规格")
    private String spec;

    @ApiModelProperty("销售单位")
    private String saleUnitName;

    @ApiModelProperty("销售单位")
    private String saleUnit;

    @ApiModelProperty("临时字段唯一值")
    private String tempUuid;

}