package com.biz.crm.nebular.sfa.tpmact.resp;

import com.biz.crm.common.param.RedisParam;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmThirtyNumberExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * tpm活动明细返回vo
 *
 * @author lf
 * @date 2021-06-10 16:44:26
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "tpm活动明细")
public class SfaTpmActDetailRespVo extends CrmThirtyNumberExtVo {

    public static final String SFA_TPM_ACT_DISTRIBUTION_ORDER = "sfa_tpm_act_distribution_order";

    public static final Long REDIS_EXPIRE_TIME = Long.valueOf(60 * 60 * 24);

    @ApiModelProperty("活动名称")
    private String actName;

    @ApiModelProperty("活动描述")
    private String actDesc;

    @ApiModelProperty("活动明细编码")
    private String actDetailCode;

    @ApiModelProperty("活动细类编码")
    private String fineCode;

    @ApiModelProperty("经销商编码")
    private String customerCode;

    @ApiModelProperty("经销商名称")
    private String customerName;

    @ApiModelProperty("支付方式名称")
    private String payTypeName;

    @ApiModelProperty("活动开始时间")
    private String beginDate;

    @ApiModelProperty("活动结束时间")
    private String endDate;

    @ApiModelProperty("是否采集活动数据(Y/N)")
    private String isCollectActData;

    @ApiModelProperty("是否采集分销订单(Y/N)")
    private String isCollectDistributionOrder;

    @ApiModelProperty("是否签署陈列协议(Y/N)")
    private String isSignDisplayAgreement;

    @ApiModelProperty("陈列协议id")
    private String displayAgreementId;

    @ApiModelProperty("是否控制活动费用(Y/N)")
    private String isControlActFee;

    @ApiModelProperty("陈列协议-现金协议,货品协议")
    private String paymentMethod;

    @CrmDict(typeCode = "payment_method", dictCodeField = "paymentMethod")
    @ApiModelProperty("陈列协议-现金协议,货品协议")
    private String paymentMethodName;

    @ApiModelProperty("活动折让价格")
    private BigDecimal eventPrice;

    @ApiModelProperty("公司承担金额")
    private BigDecimal hdCommitment;

    @ApiModelProperty("分销订单类型")
    private String distributionOrderType;

    @ApiModelProperty("分销订单id-拜访页面使用")
    private String distributionOrderId;

    @ApiModelProperty("采集活动数据id-拜访页面使用")
    private String actCollectDataId;

    @ApiModelProperty("分销订单类型")
    private String distributionOrderTypeName;

    @ApiModelProperty("采集活动数据列表")
    private List<ExecuteDataRespVo> actCollectDataList;

    @ApiModelProperty("分销订单采集数据列表")
    private List<ExecuteDataRespVo> actCollectDistributionOrderList;


    public static String buildRedisKey(String actDetailCode) {
        DateTimeFormatter yyyyMMdd = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String now = LocalDate.now().format(yyyyMMdd);
        return SFA_TPM_ACT_DISTRIBUTION_ORDER + RedisParam.DELIMITER + actDetailCode + RedisParam.DELIMITER + now;
    }

    public static Map<String, Object> buildRedisDistributionOrderType(String type) {
        Map<String, Object> map = new HashMap<>();
        map.put(SFA_TPM_ACT_DISTRIBUTION_ORDER, type);
        return map;
    }


}