package com.biz.crm.nebular.sfa.tpmact.resp;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * tpm活动返回vo
 *
 * @author lf
 * @date 2021-06-10 16:44:26
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "tpm活动")
public class SfaTpmActRespVo extends CrmBaseVo implements Serializable {
    @ApiModelProperty("活动编码")
    private String actDetailCode;

    @ApiModelProperty("活动编码")
    private String actCode;

    @ApiModelProperty("活动名称")
    private String actName;

    @ApiModelProperty("活动描述")
    private String actDesc;

    @ApiModelProperty("开始时间-年月日")
    private String beginDate;

    @ApiModelProperty("结束时间-年月日")
    private String endDate;

    @ApiModelProperty("活动总金额")
    private String totalAmount;

    @ApiModelProperty("活动总金额")
    private String actAmount;

    @ApiModelProperty("已使用金额")
    private BigDecimal usedAmount;

    @ApiModelProperty("本店已使用金额")
    private BigDecimal currentUsedAmount;

    @ApiModelProperty("活动状态")
    private String actStatusName;

    /**
     * 终端编码
     */
    private String terminalCode;

    /**
     * 是否签署陈列协议 Y/N
     */
    private String isSignDisplayAgreement;
}