package com.biz.crm.nebular.sfa.visitstep.visitoffline;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductBySfaRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRespVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author lf
 * @describe
 * @project crm
 * @package com.biz.crm.nebular.sfa.visitstep.visitoffline
 * @date 2021/6/23 14:52
 */
@Data
@ApiModel("拜访离线数据vo")
public class VisitOffLineDataVo extends CrmExtTenVo implements Serializable {

    @ApiModelProperty("redisHashKey")
    private String redisHashKey;

    @ApiModelProperty("被协访人员账号")
    private String coverHelpUserName;

    @ApiModelProperty("被协访人员姓名")
    private String coverHelpRealName;

    @ApiModelProperty("人员账号")
    private String visitUserName;

    @ApiModelProperty("人员姓名")
    private String visitRealName;

    @ApiModelProperty("人员职位编码")
    private String visitPosCode;

    @ApiModelProperty("人员职位名称")
    private String visitPosName;

    @ApiModelProperty("拜访日期yyyy-MM-dd")
    private String visitDate;

    @ApiModelProperty("客户编码")
    private String clientCode;

    @ApiModelProperty("客户名称")
    private String clientName;

    @ApiModelProperty("终端照片")
    private String clientPhoto;

    @ApiModelProperty("进店时间")
    private String inStore;

    @ApiModelProperty("进店地址")
    private String inStoreAddress;

    @ApiModelProperty("步骤列表")
    private List<VisitStepOffLienVo> steps;

    @ApiModelProperty("全量商品数据-代客下单等....")
    private List<MdmProductBySfaRespVo> productRespVos;

    @ApiModelProperty("产品层级数据")
    private List<MdmProductLevelVo> productLevelVoList;

    @Data
    @ApiModel("产品层级")
    public static class MdmProductLevelVo{

        @ApiModelProperty("产品层级编码")
        private String productLevelCode;

        @ApiModelProperty("产品层级名称")
        private String productLevelName;

        @ApiModelProperty("产品层级类型")
        private String productLevelType;

        @ApiModelProperty("产品层级类型名称")
        private String productLevelTypeName;

        @ApiModelProperty("上级产品层级名称")
        private String parentName;

        @ApiModelProperty("上级产品层级编码")
        private String parentCode;

        @ApiModelProperty("下一层级-产品层级")
        private List<MdmProductLevelVo> productLevelList;

        @ApiModelProperty("产品层级-产品信息")
        private List<MdmProductVo> productList;

    }


    @Data
    @ApiModel("产品层级-产品信息")
    public static class MdmProductVo{
        @ApiModelProperty("商品编码")
        private String productCode;

        @ApiModelProperty("商品名称")
        private String productName;
    }
}
