package com.biz.crm.nebular.sfa.worksign.form.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AccessLevel;
import lombok.Data;
import lombok.Setter;

/**
 * @author ren.gang
 * @ClassName SfaMonthSignDaysInfoRespVo.java
 * @Description 月度考勤日期明细
 * @createTime 2020年12月01日 00:39:00
 */
@Data
@ApiModel("月度考勤日期明细")
public class SfaMonthSignDaysInfoRespVo {

    @ApiModelProperty("用户账号")
    private String userName;
    @ApiModelProperty("考勤日期")
    private String ruleDate;
    @ApiModelProperty("考勤规则的上班时间")
    private String gotoTime;
    @ApiModelProperty("考勤规则的下班时间")
    private String gooffTime;
    @ApiModelProperty("是否工作日(Y:是)")
    private String signMust;
    @ApiModelProperty("打卡或不打卡类型(10:工作日打卡，，11:特殊日期打卡，20:非工作日不打卡,21:特殊日期不打卡,22:节假日不打卡)")
    private String signOrNonType;
//    @ApiModelProperty("请假日期明细")
//    private String leaveJson;
//    @ApiModelProperty("销假日期明细")
//    private String cancelDayJson;
//    @ApiModelProperty("工作日调整类型(1/2/3)")
//    private String overtimeType;

    public String signStatus() {
        return this.ciSignStatus + "+" + this.coSignStatus;
    }


    @ApiModelProperty("上班考勤状态")
    @Setter(AccessLevel.NONE)
    private String ciSignStatus;
    public void setCiSignStatus(String ciSignStatus) {
        this.ciSignStatus = ciSignStatus;
        if(null == this.ciSignStatus){
            this.ciSignStatus = "NONE";
        }
    }
    @ApiModelProperty("上班打卡时间")
    private String ciSignTime;
    @ApiModelProperty("下班考勤状态")
    @Setter(AccessLevel.NONE)
    private String coSignStatus;

    public void setCoSignStatus(String coSignStatus) {
        this.coSignStatus = coSignStatus;
        if(null == this.coSignStatus){
            this.coSignStatus = "NONE";
        }
    }

    @ApiModelProperty("下班打卡时间")
    private String coSignTime;

//    @ApiModelProperty("是否异常报备(Y/N)")
//    private boolean exceptionReport;

    @ApiModelProperty("考勤时间规则id")
    private String sfaSignTimeId;

}
