package com.biz.crm.nebular.sfa.worksign.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 出差申请 返回vo
 *
 * @author liuhongming
 * @date 2020-10-17 15:00:38
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "出差申请 ")
@SaturnEntity(name = "SfaTravelRespVo", description = "出差申请 ")
public class SfaTravelRespVo extends CrmExtTenVo {
    @ApiModelProperty("申请人员账号 申请人员账号")
    @SaturnColumn(description = "申请人员账号 申请人员账号")
    private String applyUserName;

    @ApiModelProperty("申请人员姓名 申请人员姓名")
    @SaturnColumn(description = "申请人员姓名 申请人员姓名")
    private String applyRealName;

    @ApiModelProperty("申请职位编码 申请职位编码")
    @SaturnColumn(description = "申请职位编码 申请职位编码")
    private String applyPosCode;

    @ApiModelProperty("申请职位名称 申请职位名称")
    @SaturnColumn(description = "申请职位名称 申请职位名称")
    private String applyPosName;

    @ApiModelProperty("申请所属组织编码 申请所属组织编码")
    @SaturnColumn(description = "申请所属组织编码 申请所属组织编码")
    private String applyOrgCode;

    @ApiModelProperty("申请所属组织名称 申请所属组织名称")
    @SaturnColumn(description = "申请所属组织名称 申请所属组织名称")
    private String applyOrgName;

    @ApiModelProperty("申请日期 申请日期(yyyy-MM-dd HH:mm:dd)")
    @SaturnColumn(description = "申请日期 申请日期(yyyy-MM-dd HH:mm:dd)")
    private String applicationDate;

    @ApiModelProperty("开始时间 开始时间(yyyy-MM-dd)")
    @SaturnColumn(description = "开始时间 开始时间(yyyy-MM-dd)")
    private String beginTime;

    @ApiModelProperty("结束时间 结束时间(yyyy-MM-dd)")
    @SaturnColumn(description = "结束时间 结束时间(yyyy-MM-dd)")
    private String endTime;

    @ApiModelProperty("出差地点 出差地点")
    @SaturnColumn(description = "出差地点 出差地点")
    private String address;

    @ApiModelProperty("出差目的 出差目的")
    @SaturnColumn(description = "出差目的 出差目的")
    private String travelObjective;

    @ApiModelProperty("审批状态 审批状态")
    @SaturnColumn(description = "审批状态 审批状态")
    private String bpmStatus;

    @ApiModelProperty("审批状态名称")
    private String bpmStatusName;

    @ApiModelProperty("审核任务id")
    private String auditTaskId;

    @ApiModelProperty("审核通过时间")
    private String passStatusDate;

    @ApiModelProperty("出差人员表 出差人员表")
    @SaturnColumn(description = "出差人员表")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<SfaTravelUserRespVo> sfaTravelUserRespVos;

    @ApiModelProperty("出差人员名称集合(逗号分隔)")
    private String travelUserNames;

    @ApiModelProperty("流程编号")
    private String processNo;


}