package com.biz.crm.nebular.sfa.worksign.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 工作日调整-列表 返回vo
 *
 * @author ren.gang
 * @date 2020-11-20 15:00:38
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "工作日调整 ")
@SaturnEntity(name = "SfaWorkOvertimeRespVo", description = "工作日调整-列表 返回vo")
public class SfaWorkOvertimeRespVo extends CrmExtTenVo {

    @ApiModelProperty("工作日调整类型(1普通调整，2节假日调整)")
    private String overtimeType;

    @ApiModelProperty("申请原因")
    @SaturnColumn(description = "申请原因")
    private String overtimeReason;

    @ApiModelProperty("人员姓名 人员姓名")
    @SaturnColumn(description = "人员姓名 人员姓名")
    private String realName;

    @ApiModelProperty("职位编码 职位编码")
    @SaturnColumn(description = "职位编码 职位编码")
    private String posCode;

    @ApiModelProperty("职位名称 职位名称")
    @SaturnColumn(description = "职位名称 职位名称")
    private String posName;

    @ApiModelProperty("所属组织编码 所属组织编码")
    @SaturnColumn(description = "所属组织编码 所属组织编码")
    private String orgCode;

    @ApiModelProperty("所属组织名称 所属组织名称")
    @SaturnColumn(description = "所属组织名称 所属组织名称")
    private String orgName;

    @ApiModelProperty("申请日期 申请日期(yyyy-MM-dd HH:mm:dd)")
    @SaturnColumn(description = "申请日期 申请日期(yyyy-MM-dd HH:mm:dd)")
    private String applicationDate;

    @ApiModelProperty("开始时间 开始时间(yyyy-MM-dd HH)")
    @SaturnColumn(description = "开始时间 开始时间(yyyy-MM-dd HH)")
    private String beginTime;

    @ApiModelProperty("结束时间 结束时间(yyyy-MM-dd HH)")
    @SaturnColumn(description = "结束时间 结束时间(yyyy-MM-dd HH)")
    private String endTime;

    @ApiModelProperty("审批状态 审批状态")
    @SaturnColumn(description = "审批状态 审批状态")
    private String bpmStatus;

    @ApiModelProperty("审批状态名称")
    private String bpmStatusName;

    @ApiModelProperty("日期明细json")
    private String timeInfoListJson;

    @ApiModelProperty("申请时长(天)")
    private String overtimeDuration;

    @ApiModelProperty("审核任务id")
    private String auditTaskId;

    @ApiModelProperty("流程id")
    private String processNo;

}