package com.biz.crm.nebular.tpm.act.req;
import com.biz.crm.common.DictItemVo;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.mdm.CrmThirtyNumberExtVo;
import com.biz.crm.nebular.tpm.act.TpmActDetailProductVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.List;
import java.util.Date;
import java.math.BigDecimal;
import java.util.Set;

import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 活动明细信息表;请求vo
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmActDetailReqVo", description = "活动明细信息表;")
public class TpmActDetailReqVo extends CrmThirtyNumberExtVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("活动编码")
    private String actCode;

    @ApiModelProperty("活动明细编码")
    private String actDetailCode;

    @ApiModelProperty("活动大类编码")
    private String categoriesCode;

    @ApiModelProperty("活动大类名称")
    private String categoriesName;

    @ApiModelProperty("关联预算科目(科目编码)")
    private String budgetSubjectsCode;

    @ApiModelProperty("关联预算科目名称")
    private String budgetSubjectsName;


    @ApiModelProperty("活动细类编码")
    private String fineCode;

    @ApiModelProperty("活动细类名称")
    private String fineName;

    @ApiModelProperty("活动细类编码或者名称")
    private String fineCodeOrName;

    @ApiModelProperty("企业组织编码")
    private String orgCode;

    @ApiModelProperty("企业组织名称")
    private String orgName;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("渠道")
    private String channel;

    @ApiModelProperty("渠道名称")
    private String channelName;

    @ApiModelProperty("客户所属组织编码")
    private String customerOrgCode;

    @ApiModelProperty("客户所属组织编码")
    private String customerOrgName;

    @ApiModelProperty("产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    private String productName;

    @ApiModelProperty("产品层级编码")
    private String productLevelCode;

    @ApiModelProperty("产品层级名称")
    private String productLevelName;

    @ApiModelProperty("陈列产品层级编码")
    private String displayProductLevelCode;

    @ApiModelProperty("陈列产品层级名称")
    private String displayProductLevelName;

    @ApiModelProperty("物料编码")
    private String materialCode;

    @ApiModelProperty("物料名称")
    private String materialName;

    @ApiModelProperty("物料价格")
    private BigDecimal materialPrice;

    @ApiModelProperty("物料单位(字典)")
    private String materialUnit;

    @ApiModelProperty("物料单位名称")
    private String materialUnitName;

    @ApiModelProperty("数量")
    private Long num;

    @ApiModelProperty("最小包装量")
    private Long miniPackNum;

    @ApiModelProperty("门店编码")
    private String terminalCode;

    @ApiModelProperty("门店名称")
    private String terminalName;

    @ApiModelProperty("预估销售额")
    private BigDecimal forecastSalesAmount;

    @ApiModelProperty("费用申请金额")
    private BigDecimal applyAmount;

    @ApiModelProperty("支付方式(字典编码)")
    private String payType;

    @ApiModelProperty("支付方式名称")
    private String payTypeName;

    @ApiModelProperty("支付方式类型(字典编码)")
    private String payTypeType;

    @ApiModelProperty("执行开始日期")
    private String executeBeginDate;

    @ApiModelProperty("执行开始时间")
    private String executeBeginDateSecond;

    @ApiModelProperty("执行结束日期")
    private String executeEndDate;

    @ApiModelProperty("执行结束时间")
    private String executeEndDateSecond;

    @ApiModelProperty("费用所属年月")
    private String feeDateStr;

    @ApiModelProperty("分摊分组编码(未分摊为空)")
    private String feeShareGroupId;

    @ApiModelProperty("支付方式列表(字典编码)")
    private String payTypeList;

    @ApiModelProperty("支付方式(集合的json,字典)")
    private List<DictItemVo> payTypes;

    @ApiModelProperty("币种")
    private String currencyType;

    @ApiModelProperty("币种名称")
    private String currencyTypeName;

    @ApiModelProperty("价格类型")
    private String priceType;

    @ApiModelProperty("活动细类发布需求(部门,终端,客户),字典")
    private String activityReleaseNeed;

    @ApiModelProperty("是否完全核销")
    private String isAllAudit;

    @ApiModelProperty("是否需要核销")
    private String isAudit;

    @ApiModelProperty("核销截止日期")
    private String allowAuditEndDate;

    @ApiModelProperty("核销截止时间")
    private String allowAuditEndDateSecond;

    @ApiModelProperty("已核销金额")
    private BigDecimal auditAmount;

    @ApiModelProperty("年月")
    private String actDetailYearMonth;

    @ApiModelProperty("费率(政策预估费率)")
    private BigDecimal feeRate;

    @ApiModelProperty("政策编码")
    private String policyCode;

    @ApiModelProperty("政策名称")
    private String policyName;

    @ApiModelProperty("终端售价")
    private BigDecimal terminalPrice;

    @ApiModelProperty("未税价")
    private BigDecimal ninTaxPrice;

    @ApiModelProperty("是否允许多次核销(Y/N)")
    private String isAllowRepeatAudit;

    @ApiModelProperty("排序值(记录新增时的顺序值,修改需要重排序)")
    private Integer sortNum;

    @ApiModelProperty("临时字段唯一值")
    private String tempUuid;

    @ApiModelProperty("活动折让价格")
    private BigDecimal eventPrice;

    @ApiModelProperty("公司承担金额")
    private BigDecimal hdCommitment;


    @ApiModelProperty("活动预付类型")
    private String advanceType;

    @ApiModelProperty("核销申请查询活动明细列表活动编号")
    private List<String> actCodes;

    @ApiModelProperty("活动类型")
    private String actType;

    @ApiModelProperty("活动发布需求集合")
    private List<String> activityReleaseNeedList;

    @ApiModelProperty("不包含的编码集合(弹窗使用)")
    private List<String> notInCodeList;

    @ApiModelProperty("赠品集合")
    private List<TpmActDetailProductVo> giftProductList;

    @ApiModelProperty("本品集合")
    private List<TpmActDetailProductVo> normalProductList;

    @ApiModelProperty("货补产品集合")
    private List<TpmActDetailProductVo> replenishmentProductList;

    @ApiModelProperty("执行产品集合")
    private List<TpmActDetailProductVo> executionProductList;

    @ApiModelProperty("回显编码，字符串，一般用于单选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这条数据")
    private String selectedCode;

    @ApiModelProperty("回显编码集合，字符串数组，一般用于多选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据")
    private Set<String> selectedCodeList;

    @ApiModelProperty("陈列奖励产品编码")
    private String displayAwardProductCode;

    @ApiModelProperty("陈列奖励产品名称")
    private String displayAwardProductName;

    @ApiModelProperty("是否到期")
    private Boolean isExpiration;
}