package com.biz.crm.nebular.tpm.audit.req;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.tpm.act.req.TpmActFileReqVo;
import com.biz.crm.nebular.tpm.audit.TpmAuditDetailReplenishmentProductVo;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditFileRespVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
import java.util.Set;

/**
 * 核销申请主表 请求vo
 *
 * @author huanglong
 * @date 2020-10-09 14:05:45
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmAuditReqVo", description = "核销申请主表 ")
public class TpmAuditReqVo extends CrmExtVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("核销申请名称")
    private String auditName;

    @ApiModelProperty("核销申请编码")
    private String auditCode;

    @ApiModelProperty("审批状态(字典)")
    private String approveStatus;

    @ApiModelProperty("流程编号")
    private String processCode;

    @ApiModelProperty("工作流key")
    private String workFlowKey;

    @ApiModelProperty("工作流名称")
    private String workFlowName;

    @ApiModelProperty("临时字段唯一值")
    private String tempUuid;

    @ApiModelProperty("核销明细入参")
    private List<TpmAuditDetailReqVo> detailVos;

    @ApiModelProperty("活动数据入参")
    private List<TpmAuditActReqVo> tpmAuditActReqVos;

    @ApiModelProperty("保存类型:1新增暂存,2,新增并提交审批,3,修改暂存,4修改并提交审批,5,提交审批")
    private String saveType;

    @ApiModelProperty("核销资料入参")
    private List<TpmAuditFileRespVo> auditFileRespVos;

    @ApiModelProperty("审批文件集合")
    private List<TpmAuditFileRespVo> activityFileReqVos;

    @ApiModelProperty("审批文件集合")
    private List<TpmActFileReqVo> activityFileList;

    @ApiModelProperty("是否需要占用预算")
    private Boolean occupyFeeBudgetFlag = false;

    @ApiModelProperty("需要占用预算的明细集合")
    private List<TpmAuditDetailReqVo> occupyFeeBudgetDetails;

    @ApiModelProperty("需要存储的产品集合")
    private List<TpmAuditDetailReplenishmentProductVo> auditDetailReplenishmentProductVos;

    @ApiModelProperty("审批主题")
    private String title;

    @ApiModelProperty("审批备注")
    private String approveRemarks;

    @ApiModelProperty("创建时间开始,筛选条件使用")
    private String createBeginDate;

    @ApiModelProperty("创建时间结束,筛选条件使用")
    private String createEndDate;

    @ApiModelProperty("回显编码，字符串，一般用于单选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这条数据")
    private String selectedCode;

    @ApiModelProperty("回显编码集合，字符串数组，一般用于多选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据")
    private Set<String> selectedCodeList;

    @ApiModelProperty("筛选开始时间,格式YYYY-MM-DD")
    private String filterStartTime;

    @ApiModelProperty("筛选结束时间,格式YYYY-MM-DD")
    private String filterEndTime;

    @ApiModelProperty("核销发票信息")
    List<TpmAuditInvoiceReqVo> auditInvoiceReqVos;
}