package com.biz.crm.nebular.tpm.feebudget.req;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author yb
 * @version 1.0
 * @date 2021/12/21 10:48
 * @description
 */
@ApiModel("预算费用明细报表请求对象")
@Data
public class TpmFeeBudgetDetailReportReqVo extends CrmExtVo {
    @ApiModelProperty("费用预算编码")
    private String feeBudgetCode;

    @ApiModelProperty("费用预算类型(字典)")
    private String feeBudgetType;

    @ApiModelProperty("关联预算科目(科目编码)")
    private String budgetSubjectsCode;

    @ApiModelProperty("关联预算科目名称")
    private String budgetSubjectsName;

    @ApiModelProperty("企业组织编码")
    private String orgCode;

    @ApiModelProperty("企业组织名称")
    private String orgName;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("渠道")
    private String channel;

    @ApiModelProperty("门店编码")
    private String terminalCode;

    @ApiModelProperty("门店名称")
    private String terminalName;

    @ApiModelProperty("产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    private String productName;

    @ApiModelProperty("产品层级编码")
    private String productLevelCode;

    @ApiModelProperty("产品层级名称")
    private String productLevelName;

    @ApiModelProperty("费用预算明细类型(字典)")
    private String feeBudgetDetailType;

    @ApiModelProperty("业务单据编码")
    private String businessCode;

    @ApiModelProperty("创建人姓名")
    private String createName;

    @ApiModelProperty("创建时间起始")
    private String createDateAllBegin;

    @ApiModelProperty("创建时间截止")
    private String createDateAllEnd;
}
