package com.biz.crm.nebular.dms.companyinformation;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnDomain;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;


/**
 * @Description:公司资料范围表,限定资料查看范围
 * @Author: zhangyuzhu
 * @Date: 2020/9/10 14:46
 **/
//@Entity
//@Table(name = "dms_company_information_area")
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "公司资料范围的vo")
@SaturnEntity(name = "CompanyInformationAreaVo", description = "公司资料范围")
@SaturnDomain(value = "companyinformationarea")
public class CompanyInformationAreaVo extends CrmExtVo {


    @ApiModelProperty(value = "公司资料id")
    @SaturnColumn(description = "公司资料id")
    private String informationId;

    @ApiModelProperty(value = "组织code")
    @SaturnColumn(description = "组织code")
    private String orgCode;


    @ApiModelProperty(value = "组织名称")
    @SaturnColumn(description = "组织名称")
    private String orgName;

    public String getInformationId() {
        return informationId;
    }

    public void setInformationId(String informationId) {
        this.informationId = informationId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
}
