package com.biz.crm.nebular.dms.promotion;


import com.biz.crm.nebular.mdm.CrmExtEditVo;
import com.biz.crm.util.CommonConstant;
import com.bizunited.platform.common.vo.FormInstanceUuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "促销政策编辑页面编辑请求体VO")
@SaturnEntity(name = "PromotionPolicyEditReqVo", description = "促销政策编辑页面编辑请求体VO")
public class PromotionPolicyEditReqVo extends CrmExtEditVo implements Serializable {
    /**
     * 促销编 码
     */
    @ApiModelProperty(value = "促销编码")
    @SaturnColumn(description = "促销编码")
    private String promotionPolicyCode;

    /**
     * 促销名称
     */
    @ApiModelProperty(value = "促销名称")
    @SaturnColumn(description = "促销名称")
    private String promotionPolicyName;

    /**
     * 促销政策模板模板id
     */
    @ApiModelProperty(value = "促销政策模板模板id")
    @SaturnColumn(description = "促销政策模板模板id")
    private String templateId;

    /**
     * 促销政策模板模板code
     */
    @ApiModelProperty(value = "促销政策模板模板编码")
    @SaturnColumn(description = "促销政策模板模板编码")
    private String templateCode;

    /**
     * 促销政策模板模板name
     */
    @ApiModelProperty(value = "促销政策模板模板名称")
    @SaturnColumn(description = "促销政策模板模板名称")
    private String templateName;

    /**
     * 有效期开始
     */
    @ApiModelProperty(value = "有效期开始")
    @SaturnColumn(description = "有效期开始")
    private Long beginTime;

    /**
     * 有效期结束
     */
    @ApiModelProperty(value = "有效期结束")
    @SaturnColumn(description = "有效期结束")
    private Long endTime;
    /**
     * 计算该政策是否在有效期内
     * 3个业务状态， 待执行：null，执行中：true，已结束：false
     *  @author: luoqi
     *  @Date: 2020-10-19 15:40
     *  @version: V1.0
     *  @Description:
     */
    public Boolean timeActive(){
        if(null == this.beginTime || null == this.endTime){
            return true;
        }
        long now = System.currentTimeMillis();
        if(now > this.beginTime){
            return null;
        }
        return now > this.beginTime && now < this.endTime;
    }

    /**
     * 政策叠加
     */
    @ApiModelProperty(value = "政策叠加")
    @SaturnColumn(description = "政策叠加")
    private String multipleable;

    /**
     * 首单享受
     */
    @ApiModelProperty(value = "首单享受")
    @SaturnColumn(description = "首单享受")
    private String firstOrder;

    /**
     * 促销描述
     */
    @ApiModelProperty(value = "促销描述")
    @SaturnColumn(description = "促销描述")
    private String description;

    /**
     * 商品组合起订量
     */
    @ApiModelProperty(value = "商品组合起订量")
    @SaturnColumn(description = "商品组合起订量")
    private String productsOrderQty;

    /**
     * 组合起订量类型
     */
    @ApiModelProperty(value = "组合起订量类型")
    @SaturnColumn(description = "组合起订量类型")
    private String productsOrderQtyType;



    /**
     * 促销商品
     */
    @ApiModelProperty(value = "促销商品")
    @SaturnColumn(description = "促销商品")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToOne)
    private PromotionPolicyProduct promotionPolicyProduct;

    @JsonIgnore
    @SaturnColumn(description = "促销商品")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<PromotionPolicyProductEditVo> allProducts;
    public List<PromotionPolicyProductEditVo> takeAllProducts(){
        if(null == allProducts){
            allProducts = Lists.newArrayList();
            if(null == promotionPolicyProduct){
                return allProducts;
            }
            if(null != promotionPolicyProduct.getProductsCurrentY()){
                List<PromotionPolicyProductEditVo> products = promotionPolicyProduct.getProductsCurrentY();
                products.forEach(v -> {
                    v.setCurrentProduct(CommonConstant.GLOBAL.YesOrNo.Y.getItemCode());
                });
                allProducts.addAll(products);
            }
            if(null != promotionPolicyProduct.getProductsCurrentN()){
                List<PromotionPolicyProductEditVo> products = promotionPolicyProduct.getProductsCurrentN();
                products.forEach(v -> {
                    v.setCurrentProduct(CommonConstant.GLOBAL.YesOrNo.N.getItemCode());
                });
                allProducts.addAll(products);
            }
        }
        return allProducts;
    }


    /**
     * 促销规则
     */
    @ApiModelProperty(value = "促销规则")
    @SaturnColumn(description = "促销规则")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToOne)
    private PromotionPolicyRule promotionPolicyRule;
    @JsonIgnore
    @SaturnColumn(description = "促销商品")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<PromotionPolicyRuleEditVo> allRules;
    public List<PromotionPolicyRuleEditVo> takeAllRules(){
        if(null == allRules){
            allRules = Lists.newArrayList();
            if(null == promotionPolicyRule){
                return allRules;
            }
            if(null != promotionPolicyRule.getRulesAsCalculate()){
                allRules.addAll(promotionPolicyRule.getRulesAsCalculate());
            }
            if(null != promotionPolicyRule.getRulesAsCondition()){
                allRules.addAll(promotionPolicyRule.getRulesAsCondition());
            }
            if(null != promotionPolicyRule.getRulesAsLimited()){
                allRules.addAll(promotionPolicyRule.getRulesAsLimited());
            }
        }
        return allRules;
    }
    /**
     * 促销范围
     */
    @ApiModelProperty(value = "促销范围")
    @SaturnColumn(description = "促销范围")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToOne)
    private PromotionPolicyScope promotionPolicyScope;
    @JsonIgnore
    @SaturnColumn(description = "促销商品")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<PromotionPolicyScopeEditVo> allScopes;

//    /**
//     * 当用户没有指定范围时，可以生成默认范围对象
//     *  @author: luoqi
//     *  @Date: 2020-10-20 15:13
//     *  @version: V1.0
//     *  @Description:
//     */
//    public void buildDefToEmptyScope(){
//        if(CollectionUtils.isEmpty(allScopes)){
//            if(null == allScopes) {
//                allScopes = Lists.newArrayList();
//            }
//            PromotionPolicyScopeEditVo def = new PromotionPolicyScopeEditVo();
//            def.setContainable(CommonConstant.GLOBAL.YesOrNo.N.getItemCode());
//            def.setPromotionPolicyCode(this.promotionPolicyCode);
//            def.setPromotionPolicyId(this.id);
//            def.setPromotionPolicyName(this.promotionPolicyName);
//            def.setScopeCode(PromotionPolicyScopeVo.DEF_SCOPE_CODE);
//            def.setScopeName(PromotionPolicyScopeVo.DEF_SCOPE_CODE);
//            def.setScopeType(PromotionPolicyScopeVo.DEF_SCOPE_CODE);
//            allScopes.add(def);
//        }
//
//    }
    public List<PromotionPolicyScopeEditVo> takeAllScopes(){
        if(null == allScopes){
            allScopes = Lists.newArrayList();
            if(null == promotionPolicyScope){
                return allScopes;
            }
            this.doCollectScopeToAll(promotionPolicyScope.getScopesAsChannel()
                    , CommonConstant.DMS.PromotionPolicyScopeType.CHANNEL);
            this.doCollectScopeToAll(promotionPolicyScope.getScopesAsCust()
                    , CommonConstant.DMS.PromotionPolicyScopeType.CUST);
            this.doCollectScopeToAll(promotionPolicyScope.getScopesAsOrg()
                    , CommonConstant.DMS.PromotionPolicyScopeType.ORG);
        }
        return allScopes;
    }
    /**
     * 收集促销范围到 allScopes内
     *  @author: luoqi
     *  @Date: 2020-10-20 11:31
     *  @version: V1.0
     *  @Description:
     */
    private void doCollectScopeToAll(PromotionPolicyScopeGroup scopeGroup, CommonConstant.DictItem dictItem){
        if(null == scopeGroup){
            return;
        }
        if(null != scopeGroup.getContainN()){
            List<PromotionPolicyScopeEditVo> scopeEditVos = scopeGroup.getContainN();
            scopeEditVos.forEach(v -> {
                v.setContainable(CommonConstant.GLOBAL.YesOrNo.N.getItemCode());
                v.setScopeType(dictItem.getItemCode());
            });
            allScopes.addAll(scopeEditVos);
        }
        if(null != scopeGroup.getContainY()){
            List<PromotionPolicyScopeEditVo> scopeEditVos = scopeGroup.getContainY();
            scopeEditVos.forEach(v -> {
                v.setContainable(CommonConstant.GLOBAL.YesOrNo.Y.getItemCode());
                v.setScopeType(dictItem.getItemCode());
            });
            allScopes.addAll(scopeGroup.getContainY());
        }
    }





    //####################################### 内部类 ##########################################

    @ApiModel(value = "促销政策编辑页面-促销范围")
    @Data
    @SaturnEntity(name = "PromotionPolicyScope", description = "促销政策编辑页面-促销范围")
    public static class PromotionPolicyScope extends FormInstanceUuidVo implements Serializable{
        /**
         * 促销范围-组织
         */
        @ApiModelProperty(value = "促销范围-组织")
        @SaturnColumn(description = "促销范围-组织")
        @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToOne)
        private PromotionPolicyScopeGroup scopesAsOrg;
        /**
         * 促销范围-渠道
         */
        @ApiModelProperty(value = "促销范围-渠道")
        @SaturnColumn(description = "促销范围-渠道")
        @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToOne)
        private PromotionPolicyScopeGroup scopesAsChannel;
        /**
         * 促销范围-客户
         */
        @ApiModelProperty(value = "促销范围-客户")
        @SaturnColumn(description = "促销范围-客户")
        @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToOne)
        private PromotionPolicyScopeGroup scopesAsCust;
    }
    @ApiModel(value = "促销政策编辑页面-促销范围-类型分组")
    @Data
    @SaturnEntity(name = "PromotionPolicyScopeGroup", description = "促销政策编辑页面-促销范围-类型分组")
    public static class PromotionPolicyScopeGroup extends FormInstanceUuidVo implements Serializable{
        /**
         * 促销范围-包含
         */
        @ApiModelProperty(value = "促销范围-包含")
        @SaturnColumn(description = "促销范围-包含")
        @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
        private List<PromotionPolicyScopeEditVo> containY;
        /**
         * 促销范围-非包含
         */
        @ApiModelProperty(value = "促销范围-非包含")
        @SaturnColumn(description = "促销范围-非包含")
        @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
        private List<PromotionPolicyScopeEditVo> containN;
    }

    @ApiModel(value = "促销政策编辑页面-促销商品")
    @Data
    @SaturnEntity(name = "PromotionPolicyProduct", description = "促销政策编辑页面-促销商品")
    public static class PromotionPolicyProduct extends FormInstanceUuidVo implements Serializable{
        /**
         * 促销商品-本品
         */
        @ApiModelProperty(value = "促销商品-本品")
        @SaturnColumn(description = "促销商品-本品")
        @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
        private List<PromotionPolicyProductEditVo> productsCurrentY;
        /**
         * 促销商品-赠品
         */
        @ApiModelProperty(value = "促销商品-赠品")
        @SaturnColumn(description = "促销商品-赠品")
        @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
        private List<PromotionPolicyProductEditVo> productsCurrentN;
    }

    @ApiModel(value = "促销政策编辑页面-促销规则")
    @SaturnEntity(name = "PromotionPolicyRule", description = "促销政策编辑页面-促销规则")
    @Data
    public static class PromotionPolicyRule extends FormInstanceUuidVo implements Serializable{
        /**
         * 促销规则-条件
         */
        @ApiModelProperty(value = "促销规则-条件")
        @SaturnColumn(description = "促销规则-条件")
        @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
        private List<PromotionPolicyRuleEditVo> rulesAsCondition;
        /**
         * 促销规则-计算
         */
        @ApiModelProperty(value = "促销规则-计算")
        @SaturnColumn(description = "促销规则-计算")
        @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
        private List<PromotionPolicyRuleEditVo> rulesAsCalculate;
        /**
         * 促销规则-限量
         */
        @ApiModelProperty(value = "促销规则-限量")
        @SaturnColumn(description = "促销规则-限量")
        @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
        private List<PromotionPolicyRuleEditVo> rulesAsLimited;
    }
}
