package com.biz.crm.nebular.dms.promotion;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;


/**
 * 促销政策模板
 *  @author: luoqi
 *  @Date: 2020-10-15 14:56
 *  @version: V1.0
 *  @Description:
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "促销政策模板")
@SaturnEntity(name = "PromotionPolicyTemplateVo", description = "促销政策模板")
public class PromotionPolicyTemplateVo extends CrmExtVo {


    /**
     * 模板编码
     */
    @ApiModelProperty(value = "模板编码")
    @SaturnColumn(description = "模板编码")
//    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private String templateCode;

    @ApiModelProperty(value = "模板名称")
    @SaturnColumn(description = "模板名称")
    private String templateName;
    /**
     * 促销类型
     */
    @ApiModelProperty(value = "促销类型")
    @SaturnColumn(description = "促销类型")
    private String promotionType;

    /**
     * 促销商品
     */
    @ApiModelProperty(value = "促销商品")
    @SaturnColumn(description = "促销商品")
    private String promotionProduct;

    /**
     * 是否阶梯
     */
    @ApiModelProperty(value = "是否阶梯")
    @SaturnColumn(description = "是否阶梯")
    private String ladderable;

    /**
     * 首单优惠
     */
    @ApiModelProperty(value = "首单优惠")
    @SaturnColumn(description = "首单优惠")
    private String firstOrder;



}
