package com.biz.crm.nebular.dms.promotion;

import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;


/**
 * 促销规则
 *  @author: luoqi
 *  @Date: 2020-10-15 14:56
 *  @version: V1.0
 *  @Description:
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "促销规则编辑页面vo")
public class PromotionRuleEditVo implements Serializable {
    @ApiModelProperty(value = "id")
    private String id;
    /**
     * 规则名称
     */
    @ApiModelProperty(value = "规则名称")
    private String ruleName;

    /**
     * 规则编码
     */
    @ApiModelProperty(value = "规则编码")
    private String ruleCode;

    /**
     * 规则类型
     */
    @ApiModelProperty(value = "规则类型")
    private String ruleType;

    /**
     * 促销类型
     */
    @ApiModelProperty(value = "促销类型")
    private String promotionType;

    /**
     * 函数体
     */
    @ApiModelProperty(value = "函数体")
    private String funcBody;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remarks;

    /**
     * 调试参数
     */
    @ApiModelProperty(value = "调试参数")
    private String testJsonParams;


//    @ApiModelProperty(value = "调试参数Example")
//    private static final TestParam paramExample;

//    @ApiModelProperty(value = "函数体Example")
//    private static final String funcBodyExample = "def result = paramA * paramC; if('xiang'.equals(paramB)){ return result;} else {return result * 10;}";

//    public String getFuncBodyExample() {
//        return PromotionRuleEditVo.funcBodyExample;
//    }
//
//    public TestParam getParamExample() {
//        return PromotionRuleEditVo.paramExample;
//    }

//    static {
//        paramExample = new TestParam();
//        paramExample.setText("TestParam");
//
//        KeyValParamControl input = new KeyValParamControl();
//        input.setDescription("请输入paramA");
//        input.setControlType(KeyValParamControl.ControlType.input.name());
//        input.setKey("paramA");
//        input.setValue(10);
//        KeyValParamControl select = new KeyValParamControl();
//        select.setDescription("请选择paramB");
//        select.setControlType(KeyValParamControl.ControlType.select.name());
//        select.setKey("paramB");
//        select.setValue("xiang");
//        select.setSelectOptions(Lists.newArrayList(new SelectOption("xiang", "箱"), new SelectOption("ping", "瓶")));
//        KeyValParamControl def = new KeyValParamControl();
//        def.setKey("paramC");
//        def.setValue(55);
//        List<KeyValParamControl> controls = Lists.newArrayList(input, select, def);
//        paramExample.setControls(controls);
//    }
    /**
     * 调试参数
     *  @author: luoqi
     *  @Date: 2020-10-21 15:52
     *  @version: V1.0
     *  @Description:
     */
    @Data
    public static class TestParam implements Serializable{
        /**
         * 描述
         */
        private String text;
        /**
         * 规则函数参数控件列表
         */
        private List<KeyValParamControl> controls;
    }

    /**
     * 控件
     *  @author: luoqi
     *  @Date: 2020-10-21 15:53
     *  @version: V1.0
     *  @Description:
     */
    @Data
    public static class KeyValParamControl implements Serializable{
        public enum  ControlType{input, select}
        /**
         * 控件描述
         */
        private String description;
        /**
         * 控件类型
         */
        private String controlType;
        /**
         * 参数key
         */
        private String key;
        /**
         * 参数值
         */
        private Object value;
        /**
         * 下拉列表
         */
        private List<SelectOption> selectOptions;
    }

    /**
     * 下拉对象
     *  @author: luoqi
     *  @Date: 2020-10-21 15:53
     *  @version: V1.0
     *  @Description:
     */
    @Data
    public static class SelectOption implements Serializable{
        public SelectOption(){}
        public SelectOption(String key, String value){
            this.key = key;
            this.value = value;
        }
        private String key;
        private String value;
    }

}
