package com.biz.crm.nebular.mdm.cusorg;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import com.biz.crm.nebular.mdm.base.MdmRuleReqVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnDomain;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.*;
import lombok.experimental.Accessors;

import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/8/26 11:01
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "客户组织的vo")
@SaturnDomain(value = "cusorgvo")
@SaturnEntity(name = "CusOrgVo", description = "客户组织")
public class CusOrgVo extends MdmRuleReqVo {

    @ApiModelProperty("公共树编码")
    private String code;

    @ApiModelProperty(value = "客户组织编码")
    @SaturnColumn(description = "客户组织编码")
    private String customerOrgCode;

    @ApiModelProperty(value = "客户组织名称")
    @SaturnColumn(description = "客户组织名称")
    private String customerOrgName;

    @ApiModelProperty(value = "客户组织层级")
    @SaturnColumn(description = "客户组织层级")
    private String customerOrgLevel;

    @ApiModelProperty(value = "客户组织层级名称")
    @SaturnColumn(description = "客户组织层级名称")
    @CrmDict(typeCode = DictConstant.CUS_ORG_LEVEL,dictCodeField = "customerOrgLevel")
    private String customerOrgLevelName;

    @ApiModelProperty(value = "客户组织类型")
    @SaturnColumn(description = "客户组织类型")
    private String customerOrgLevelType;

    @ApiModelProperty(value = "客户组织类型名称")
    @SaturnColumn(description = "客户组织类型名称")
    @CrmDict(typeCode = DictConstant.CUS_ORG_TYPE,dictCodeField = "customerOrgLevelType")
    private String customerOrgLevelTypeName;

    @ApiModelProperty(value = "客户组织描述")
    @SaturnColumn(description = "客户组织描述")
    private String customerOrgDesc;

    @ApiModelProperty(value = "上级组织名称")
    @SaturnColumn(description = "上级组织名称")
    private String parentName;

    @ApiModelProperty("编码或名称")
    @SaturnColumn(description = "编码或名称")
    private String codeOrgName;

}
