package com.biz.crm.nebular.mdm.customer;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;

/**
 * 返回vo
 *
 * @author zxw
 * @date 2020-09-02 14:10:26
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "客户信息联系人")
@SaturnEntity(name = "MdmCustomerContactRespVo", description = "客户信息联系人")
public class MdmCustomerContactRespVo extends CrmExtVo {

    @ApiModelProperty("客户编码")
    @SaturnColumn(description = "客户编码")
    private String customerCode;

    @ApiModelProperty("联系人姓名")
    @SaturnColumn(description = "联系人姓名")
    private String contactName;

    @ApiModelProperty("联系人电话")
    @SaturnColumn(description = "联系人电话")
    private String contactPhone;

}