package com.biz.crm.nebular.mdm.customer;

import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 请求vo
 *
 * @author zxw
 * @date 2020-09-02 14:10:25
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "MdmCustomerTerminalReqVo", description = "客户终端查询入参")
public class MdmCustomerTerminalReqVo extends PageVo {


    @ApiModelProperty("客户编码")
    @NotBlank(message = "客户编码不能为空")
    private String customerCode;

    @ApiModelProperty("1：未关联任何用户的终端，2：未关联当前客户的终端，3:关联当前客户的终端")
    @NotNull(message = "客户终端查询类型不能为空")
    private Integer queryType;

    @ApiModelProperty("终端编码或名称")
    private String terminalNameOrCode;

    @ApiModelProperty("终端类型")
    private String terminalType;
}