package com.biz.crm.nebular.mdm.dict.req;

import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 数据字典扩展字段配置表请求vo
 *
 * @author Tao.Chen
 * @date 2020-10-30 10:46:50
 */
@Data
@Builder
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "EngineDictAttrConfReqVo", description = "数据字典扩展字段配置表")
public class EngineDictAttrConfReqVo extends PageVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("数据字典类型编码")
    private String dictTypeCode;

    //@ApiModelProperty("字段编码")
    //private String fieldCode;

    @ApiModelProperty("字段名称")
    private String fieldName;

    @ApiModelProperty("是否必填")
    private String required;

    @ApiModelProperty("显示顺序")
    private Integer showOrder;

    @ApiModelProperty("扩展属性字段")
    private String extField;

    @ApiModelProperty("下拉框数据字典")
    private String selectDictType;

    @ApiModelProperty("数据字典类型ID")
    private String dictEntityId;

}