package com.biz.crm.nebular.mdm.dict.resp;

import com.biz.crm.nebular.mdm.PageVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 字典返回vo
 *
 * @author Tao.Chen
 * @date 2020-10-26 16:47:25
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "字典")
@SaturnEntity(name = "EngineDictRespVo", description = "字典")
public class EngineDictRespVo extends PageVo {

    @ApiModelProperty("字典的说明")
    @SaturnColumn(description = "字典的说明")
    private String description;

    @ApiModelProperty("字典的类型编号")
    @SaturnColumn(description = "字典的类型编号")
    private String dictCode;

    @ApiModelProperty("字典的启用状态")
    @SaturnColumn(description = "字典的启用状态")
    private Boolean dictStatus;

    @ApiModelProperty("字典的标题")
    @SaturnColumn(description = "字典的标题")
    private String dictTitle;

    @ApiModelProperty("字典的运营范围,先固定值为 通用/业务")
    @SaturnColumn(description = "字典的运营范围,先固定值为 通用/业务")
    private String dictType;

    @ApiModelProperty("字典明细数量")
    @SaturnColumn(description = "字典明细数量")
    private Integer itemNum;

    @ApiModelProperty("最后更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @SaturnColumn(description = "最后更新时间")
    private Date modifyTime;

    @ApiModelProperty("值类型")
    @SaturnColumn(description = "值类型")
    private String valueType;

    @ApiModelProperty("工程名")
    @SaturnColumn(description = "工程名")
    private String projectName;

    @ApiModelProperty("创建时间")
    @SaturnColumn(description = "创建时间")
    private Date createTime;

    @ApiModelProperty("父级分组")
    @SaturnColumn(description = "父级分组")
    private String categoryId;

    @ApiModelProperty("模块编码")
    @SaturnColumn(description = "模块编码")
    private String cateCode;

    @ApiModelProperty("模块名称")
    @SaturnColumn(description = "模块名称")
    private String cateName;

}