package com.biz.crm.nebular.mdm.humanarea;

import com.biz.crm.nebular.mdm.base.MdmRuleReqVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 描述业务系统中的组织机构信息请求vo
 *
 * @author zxw
 * @date 2020-09-18 14:06:30
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "EngineOrgReqVo", description = "描述业务系统中的组织机构信息")
public class EngineOrgReqVo extends MdmRuleReqVo {

    @ApiModelProperty("id集合")
    private List<String> ids;

    @ApiModelProperty("组织机构唯一编号")
    private String orgCode;

    @ApiModelProperty("组织机构描述")
    private String orgDesc;

    @ApiModelProperty("组织机构名称")
    private String orgName;

    @ApiModelProperty("组织机构类型")
    private Integer orgType;

    @ApiModelProperty("组织机构所在层级编码")
    private String orgLevel;

    @ApiModelProperty("组织机构所在层级名称")
    private String orgLevelName;

    @ApiModelProperty("组织编码集合")
    private List<String> orgCodeList;

    @ApiModelProperty("临时公共树字段")
    private String code;

    @ApiModelProperty("查询可选择的上级组织编码")
    private String currentOrgCode;

    @ApiModelProperty("降维编码")
    private String ruleCode;

}