package com.biz.crm.nebular.mdm.positioin.resp;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 职位级别 返回vo
 *
 * @author Tao.Chen
 * @date 2020-10-22 10:56:51
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "职位级别")
@SaturnEntity(name = "MdmPositionLevelRespVo", description = "职位级别")
public class MdmPositionLevelRespVo extends CrmBaseVo {

    @ApiModelProperty("职位级别编码")
    @SaturnColumn(description = "职位级别编码")
    private String positionLevelCode;

    @ApiModelProperty("职位级别名称")
    @SaturnColumn(description = "职位级别名称")
    private String positionLevelName;

    @ApiModelProperty("角色编码")
    @SaturnColumn(description = "角色编码")
    private String roleCode;

    @ApiModelProperty("角色名称")
    @SaturnColumn(description = "角色名称")
    private String roleName;

    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    @ApiModelProperty("关联角色集合")
    @SaturnColumn(description = "关联角色集合")
    private List<MdmPositionLevelRoleRespVo> roleList;

}