package com.biz.crm.nebular.mdm.product.resp;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 返回vo
 *
 * @author crm
 * @date 2020-08-27 16:29:11
 */
@Data
@ApiModel(value = "商品物料信息")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@SaturnEntity(name = "MdmProductMaterialRespVo", description = "商品物料信息")
public class MdmProductMaterialRespVo extends CrmExtVo {

    @ApiModelProperty("物料数量")
    @SaturnColumn(description = "物料数量")
    private Integer count;

    @ApiModelProperty("物料编码")
    @SaturnColumn(description = "物料编码")
    private String materialCode;

    @ApiModelProperty("物料名称")
    @SaturnColumn(description = "物料名称")
    private String materialName;

    @ApiModelProperty("销售单位")
    @SaturnColumn(description = "销售单位")
    private String saleUnitName;

    @ApiModelProperty("销售单位")
    @SaturnColumn(description = "销售单位名称")
    private String saleUnit;

    @ApiModelProperty("基本单位")
    @SaturnColumn(description = "基本单位名称")
    private String baseUnitName;

    @ApiModelProperty("基本单位")
    @SaturnColumn(description = "基本单位")
    private String baseUnit;

    @ApiModelProperty("商品编码")
    @SaturnColumn(description = "商品编码")
    private String productCode;


    @ApiModelProperty("比例")
    @SaturnColumn(description = "比例")
    private BigDecimal ratio;

    @SaturnColumn(description = "基本信息")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.ManyToOne)
    private MdmProductRespVo productRespVo;

    public Integer getCount() {
        return count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public BigDecimal getRatio() {
        return ratio;
    }

    public void setRatio(BigDecimal ratio) {
        this.ratio = ratio;
    }

    public MdmProductRespVo getProductRespVo() {
        return productRespVo;
    }

    public void setProductRespVo(MdmProductRespVo productRespVo) {
        this.productRespVo = productRespVo;
    }
}