package com.biz.crm.nebular.mdm.productlevel.req;

import com.biz.crm.nebular.mdm.base.MdmRuleReqVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 请求vo
 *
 * @author Liao.Hua
 * @date 2020-09-01 14:13:56
 */
@Data
@ApiModel(value = "MdmProductLevelReqVo", description = "")
public class MdmProductLevelReqVo extends MdmRuleReqVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("产品层级编码")
    @NotBlank(message = "产品层级编码不能为空")
    private String productLevelCode;

    @ApiModelProperty("产品层级名称")
    private String productLevelName;

    @ApiModelProperty("产品层级类型")
    private String productLevelType;

    @ApiModelProperty("上级编码")
    private String parentCode;

}
