package com.biz.crm.nebular.mdm.terminal.req;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 终端供应关系
 * @author Liao Hua
 * @date 2020/9/5 3:46 下午
 */
@Data
@ApiModel(value = "终端供应关系")
@SaturnEntity(name = "MdmTerminalSupplyRespVo", description = "终端供应关系")
public class MdmTerminalSupplyReqVo extends CrmExtVo {

  @ApiModelProperty("终端编码")
  @SaturnColumn(description = "终端编码")
  private String terminalCode;

  @ApiModelProperty("业务员")
  @SaturnColumn(description = "业务员")
  private String salesman;

  @ApiModelProperty("组织编码")
  @SaturnColumn(description = "组织编码")
  private String orgCode;

  @ApiModelProperty("组织名称")
  @SaturnColumn(description = "组织名称")
  private String orgName;

  @ApiModelProperty("上级客户编码")
  @SaturnColumn(description = "上级客户编码")
  private String parentCustomerCode;

  @ApiModelProperty("上级客户名称")
  @SaturnColumn(description = "上级客户名称")
  private String parentCustomerName;
}
