package com.biz.crm.nebular.tpm.audit.resp;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditActReqVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditDetailReqVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmCostTypeFineRespVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 核销申请主表 返回vo
 *
 * @author huanglong
 * @date 2020-10-09 14:05:45
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "核销申请主表 ")
@SaturnEntity(name = "TpmAuditRespVo", description = "核销申请主表 ")
public class TpmAuditRespVo extends CrmExtVo {
    @ApiModelProperty("核销申请名称")
    @SaturnColumn(description = "核销申请名称")
    private String auditName;

    @ApiModelProperty("核销申请编码")
    @SaturnColumn(description = "核销申请编码")
    private String auditCode;

    @ApiModelProperty("审批状态(字典)")
    @SaturnColumn(description = "审批状态(字典)")
    private String approveStatus;

    @ApiModelProperty("审批状态")
    @SaturnColumn(description = "审批状态(名称)")
    private String approveStatusName;

    @ApiModelProperty("流程编号")
    @SaturnColumn(description = "流程编号")
    private String processCode;

    @ApiModelProperty("工作流key")
    @SaturnColumn(description = "工作流key")
    private String workFlowKey;

    @ApiModelProperty("工作流名称")
    @SaturnColumn(description = "工作流名称")
    private String workFlowName;

    @ApiModelProperty("临时字段唯一值")
    @SaturnColumn(description = "临时字段唯一值")
    private String tempUuid;

    @ApiModelProperty("核销明细数据")
    @SaturnColumn(description = "核销明细数据")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<TpmAuditDetailRespVo> detailVos;

    @ApiModelProperty("活动数据")
    @SaturnColumn(description = "活动数据")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<TpmAuditActRespVo> tpmAuditActReqVos;

    @ApiModelProperty("核销资料入参")
    @SaturnColumn(description = "核销资料")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<TpmAuditFileRespVo> auditFileRespVos;

}