package com.biz.crm.nebular.dms.promotion;

import com.bizunited.platform.common.vo.FormInstanceUuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;


/**
 * 促销规则编辑页面VO
 *  @author: luoqi
 *  @Date: 2020-10-15 14:56
 *  @version: V1.0
 *  @Description:
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "促销规则编辑页面VO")
@SaturnEntity(name = "PromotionPolicyRuleEditVo", description = "促销规则编辑页面VO")
public class PromotionPolicyRuleEditVo extends FormInstanceUuidVo implements Serializable {

    /**
     * 促销规则id
     */
    @ApiModelProperty(value = "促销规则id")
    @SaturnColumn(description = "促销规则id")
    private String promotionRuleId;


    /**
     * 规则编码
     */
    @ApiModelProperty(value = "规则编码")
    @SaturnColumn(description = "规则编码")
    private String ruleCode;

    /**
     * 规则名称
     */
    @ApiModelProperty(value = "规则名称")
    @SaturnColumn(description = "规则名称")
    private String ruleName;

    /**
     * 规则类型
     */
    @ApiModelProperty(value = "规则类型")
    @SaturnColumn(description = "规则类型")
    private String ruleType;

    /**
     * 促销类型
     */
    @ApiModelProperty(value = "促销类型")
    @SaturnColumn(description = "促销类型")
    private String promotionType;

    /**
     * 模板id
     */
    @ApiModelProperty(value = "模板id")
    @SaturnColumn(description = "模板id")
    private String promotionPolicyTemplateId;

    /**
     * 模板编码
     */
    @ApiModelProperty(value = "模板编码")
    @SaturnColumn(description = "模板编码")
    private String promotionPolicyTemplateCode;

    /**
     * 政策id
     */
    @ApiModelProperty(value = "政策id")
    @SaturnColumn(description = "政策id")
    private String promotionPolicyId;

    /**
     * 政策编码
     */
    @ApiModelProperty(value = "政策编码")
    @SaturnColumn(description = "政策编码")
    private String promotionPolicyCode;

    /**
     * 函数参数体
     */
    @ApiModelProperty(value = "函数参数体")
    @SaturnColumn(description = "函数参数体")
    private String params;

    @ApiModelProperty(value = "是否选中")
    @SaturnColumn(description = "是否选中")
    private Boolean selected = false;



}
