package com.biz.crm.nebular.mdm.customer;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;

/**
 * 返回vo
 *
 * @author zxw
 * @date 2020-09-02 14:10:25
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "客户信息对接人")
@SaturnEntity(name = "MdmCustomerDockingRespVo", description = "客户信息对接人")
public class MdmCustomerDockingRespVo extends CrmExtVo {

    @ApiModelProperty("客户编码")
    @SaturnColumn(description = "客户编码")
    private String customerCode;

    @ApiModelProperty("职位id")
    @SaturnColumn(description = "职位id")
    private String positionId;

    @ApiModelProperty("职位编码")
    @SaturnColumn(description = "职位编码")
    private String positionCode;

    @ApiModelProperty("职位名称")
    @SaturnColumn(description = "职位名称")
    private String positionName;

    @ApiModelProperty("组织编码")
    @SaturnColumn(description = "组织编码")
    private String orgCode;

    @SaturnColumn(description = "组织名称")
    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("联系方式")
    @SaturnColumn(description = "联系方式")
    private String contact;

    @ApiModelProperty("用户帐号")
    @SaturnColumn(description = "用户帐号")
    private String userAccount;

    @SaturnColumn(description = "用户名称")
    @ApiModelProperty("用户名称")
    private String userName;

    @ApiModelProperty("联系人电话")
    @SaturnColumn(description = "联系人电话")
    private String contactPhone;

}