package com.biz.crm.nebular.mdm.dict.dictdata.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

/**
 * @author zxw
 */
@ApiModel("字典响应")
@AllArgsConstructor
@NoArgsConstructor
@Data
@Accessors(chain = true)
public class MdmDictDataRespVo {

    @ApiModelProperty(value = "字典编码")
    private String dictCode;

    @ApiModelProperty("字典值")
    private String dictValue;

    @ApiModelProperty("字典描述")
    private String dictDesc;

    @ApiModelProperty("排序")
    private Integer orderNum;

    @ApiModelProperty(value = "上级字典id")
    private String parentId;

    @ApiModelProperty(value = "字典分类id")
    private String dictTypeId;

    @ApiModelProperty(hidden = true,value = "1：叶子节点，0：非叶子节点")
    private Integer isLeaf;
}
