package com.biz.crm.nebular.mdm.dict.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author zxw
 */

@AllArgsConstructor
@Getter
public enum MdmDictAttrEnum {

    /**
     * 属性初始化数据
     */
    MDM_DICT_KEY("mdmDictKey", "字典编码"),
    MDM_DICT_VAL("mdmDictVal", "字典值"),
    MDM_DICT_DESC("mdmDictDesc", "字典描述"),
    MDM_DICT_ORDER("mdmDictOrder", "排序");


    private final String code;
    private final String val;

    public static List<String> getAllCode() {
        return Stream.of(MdmDictAttrEnum.values()).map(x -> x.getCode()).collect(Collectors.toList());
    }

}
