package com.biz.crm.nebular.mdm.humanarea;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import com.biz.crm.nebular.mdm.PageVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 描述业务系统中的组织机构信息返回vo
 *
 * @author zxw
 * @date 2020-09-18 14:06:30
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "描述业务系统中的组织机构信息")
@SaturnEntity(name = "EngineOrgRespVo", description = "描述业务系统中的组织机构信息")
public class EngineOrgRespVo  extends CrmTreeVo {
    @ApiModelProperty("组织机构唯一编号")
    @SaturnColumn(description = "组织机构唯一编号")
    private String orgCode;

    @ApiModelProperty("组织机构描述")
    @SaturnColumn(description = "组织机构描述")
    private String orgDesc;


    @ApiModelProperty("组织机构名称")
    @SaturnColumn(description = "组织机构名称")
    private String orgName;


    @ApiModelProperty("组织机构类型")
    @SaturnColumn(description = "组织机构类型")
    private String orgType;

    @ApiModelProperty("组织机构类型名称")
    @SaturnColumn(description = "组织机构类型名称")
    private String orgTypeName;

    @ApiModelProperty("父级组织")
    @SaturnColumn(description = "父级组织")
    private String parentId;


    @ApiModelProperty("组织机构所在层级编码")
    @SaturnColumn(description = "组织机构所在层级编码")
    private String orgLevel;

    @ApiModelProperty("组织机构所在层级名称")
    @SaturnColumn(description = "组织机构所在层级名称")
    @CrmDict(typeCode = DictConstant.MDM_ORG_LEVEL, dictCodeField = "orgLevel")
    private String orgLevelName;

    @ApiModelProperty("上级组织名称")
    @SaturnColumn(description = "上级组织名称")
    private String parentName;

}