package com.biz.crm.nebular.mdm.humanarea;

import com.bizunited.platform.common.vo.UuidVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 职位下拉框返回vo
 *
 * @author Tao.Chen
 * @date 2020-09-18 14:06:30
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "职位下拉框返回vo")
@SaturnEntity(name = "EnginePositionSelectRespVo", description = "职位下拉框返回vo")
public class EnginePositionSelectRespVo extends UuidVo {

    @ApiModelProperty("职位编码")
    private String positionCode;

    @ApiModelProperty("职位名称")
    private String positionName;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("用户帐号")
    private String userAccount;

    @ApiModelProperty("用户名称")
    private String userName;

    @ApiModelProperty("组织名称/职位名称/姓名")
    private String unionName;

}